program Rob_3d

!*********************************************
! after rob diependaal, 1987
! modified hdh -> f90 oct 1997
!   updated spring 2008
!   = remove all implicit assignments
!   = use Intel Array Viewer for some figures
!   = check current LINPACK and IMSL routines
!*********************************************

use CochParms
use IFPORT                              !new 2008

INCLUDE 'link_fnl_static.h'             !new 2008 (2 lines)
!DEC$ OBJCOMMENT LIB:"libguide.lib"

IMPLICIT NONE
SAVE

integer*4, parameter :: f_in1=30
integer*4 :: k, kwrite
integer*4 :: istept, isw, ifill
integer*4 :: ios, irecl                 !new2008: irecl

logical(4) :: lexist, result            !new2008

real(dbl) :: t, et, st, deltat
real(dbl) :: rmsme
real(dbl) :: am
!real(dbl), allocatable :: yt(:)

character(len=80) :: dir='g:\\ms\\fort\\rob\\rnew\\3d-rob\\out\\'
character(len=80) :: filename,buf
character(len=5 ) :: txtn               !new2008 also: dir, and 64->80
character(len=1 ) :: ct                 !new2008

!These input parameters in the namelists provide
! an easy value adjustment option. Can be edited
! by many user interface programs.
!Just follow the proper list format and headers.
namelist /Rob3d/ iwrite,nBM,k,kwrite,et,istept,st &
			,filename,isw,ifill,epst,rl,b,rh,rho &
			,rmsme,resme,stifme,gm,am,as
namelist /hdh/ l_active, l_variable_BM_width


open (f_in1, file='Rob3d.ini', delim='apostrophe')
read (f_in1, Rob3d)
read (f_in1, hdh)
close(f_in1)

nBM1=nBM+1
ndim=2*nBM1
!now allocate size to module parameters
!allocate (yt(ndim), yp1(ndim), yp2(ndim), yp3(ndim), yp4(ndim) ) 
allocate (yp1(ndim), yp2(ndim), yp3(ndim), yp4(ndim) ) 
allocate (yst1(ndim), yst2(ndim), yst3(ndim), yst4(ndim) ) 
!allocate (work(nBM), iint(nBM), ipvt(nBM) )
allocate (work(nBM), ipvt(nBM) )
!allocate (a(nBM,nBM),alu(nBM,3),blu(nBM,1),asi(0:nBM*4),aco(0:nBM*4) )
allocate (a(nBM,nBM),asi(0:nBM*4),aco(0:nBM*4) )
allocate (d(nBM), g(nBM), yx(nBM), yxx(nBM), yxlu(nBM),rha(nBM) )
allocate (x(nBM), den(100,nBM), rnum(100,nBM) )

irecl=nBM*2


write(txtn,'( i2 )') int(am)
!buf: directory+initial part of the output-file names
buf = dir(:len_trim(dir))//txtn(:len_trim(txtn))//'dB\\'
INQUIRE(DIRECTORY=buf,EXIST=lexist)
if(.not.lexist) result = MAKEDIRQQ(buf)
buf = buf(:len_trim(buf))//filename(:len_trim(filename))

!NOTE: Rob used nr 10 for input parameters!!, not for output.
! Here we use nr 16 for the general output (formatted, text etc).
! Setting iwrite=6  in Rob3d.ini gives screen output
! Setting iwrite=16 gives output in **1.dat 

filename=buf(:len_trim(buf))//'0.dat'
open (9,  file=filename, iostat=ios, err=2000, form='unformatted')
!This first file stores the A-matrix, g-vector, and other parameters

filename=buf(:len_trim(buf))//'1.dat'
open (16, file=filename, iostat=ios, err=2000)
! if used (see note above) then stores program monitor info

filename=buf(:len_trim(buf))//'2.dat'
open (11, file=filename, iostat=ios, err=2000, form='unformatted', access='direct', recl=irecl)
!stores BM-deflection

filename=buf(:len_trim(buf))//'3.dat'
open (12, file=filename, iostat=ios, err=2000, form='unformatted', access='direct', recl=irecl)
!stored BM-velocity

filename=buf(:len_trim(buf))//'4.dat'
open (13, file=filename, iostat=ios, err=2000, form='unformatted', access='direct', recl=irecl)
!stores trans BM pressure difference

filename=buf(:len_trim(buf))//'5.dat'
open (14, file=filename, iostat=ios, err=2000, form='unformatted', access='direct', recl=10)
!stores OW-deflection

filename=buf(:len_trim(buf))//'6.dat'
open (15, file=filename, iostat=ios, err=2000, form='unformatted', access='direct', recl=10)
!stores OW-velocity

ipvt=0
deltax=rl/dfloat(nBM)
t=st
deltat=(et-st)/dfloat(k)
am = 10.**(am/20.)   !!from dB to Pa; re "p0", see presed function
amred=am/(gm*as)
rmseff=par2*rho*rl + rmsme

write(*,'(\,a)')'select classic [c] or IMSL [i] matrix solution: '
read(*,'(a1)') ct

select case (ct)
case ('c','C')
 call t3d1fma(k,kwrite,deltat,istept,t,isw,ifill)
case ('i','I')
 call t3d1fmIMSLa(k,kwrite,deltat,istept,t,isw,ifill)
end select

goto 2200
2000 write(iwrite,'(a, i5)') ' error in open statement, ios = ', ios
2200 continue

!note: open units need to be closed, and no error occurs when the
!      closed unit was not open.
close ( 9)
close (16)
close (11)
close (12)
close (13)
close (14)
close (15)

deallocate (yp1,  yp2,  yp3,  yp4) 
deallocate (yst1, yst2, yst3, yst4) 
deallocate (work, ipvt )
deallocate (a,asi,aco )
deallocate (d, g, yx, yxx, yxlu, rha)
deallocate (x, den, rnum )

end program Rob_3d